import {React, PureComponent, B, mix} from '../base';

import convertPrice from '../../lib/currencies/convertPrice';

import Price from '../Price/Price';
import InformationIcon from '../basic/InformationIcon';

const b = B('SuburbanTariffsCategories');

const CATEGORY_USUAL = 'usual';
const CATEGORY_SEASON = 'seasonTicket';
const CATEGORY_SPECIAL = 'special';
const categoryPriorities = [CATEGORY_USUAL, CATEGORY_SEASON, CATEGORY_SPECIAL];

import categoriesKeyset from '../../i18n/suburban-tariffs-categories';

export default class SuburbanTariffsCategories extends PureComponent {
    render() {
        const {className, currencies, categories} = this.props;

        return (
            <ul className={mix(b(), className)}>
                {Object.keys(categories)
                    .filter(categoryKey => categories[categoryKey].length > 0)
                    .sort(
                        (keyA, keyB) =>
                            categoryPriorities.indexOf(keyA) -
                            categoryPriorities.indexOf(keyB),
                    )
                    .map(categoryKey => (
                        <li className={b('category')} key={categoryKey}>
                            <h4 className={b('categoryTitle')}>
                                {categoriesKeyset.get(categoryKey)}
                            </h4>
                            <ul className={b('tariffs')}>
                                {categories[categoryKey]
                                    .sort(
                                        (tariffA, tariffB) =>
                                            tariffA.order - tariffB.order,
                                    )
                                    .map(
                                        (
                                            {title, price, description},
                                            index,
                                        ) => (
                                            <li
                                                className={b('tariff')}
                                                key={index}
                                            >
                                                <div
                                                    className={b('tariffTitle')}
                                                >
                                                    {title}
                                                    {description &&
                                                        description.trim() && (
                                                            <InformationIcon
                                                                hint={
                                                                    description
                                                                }
                                                            />
                                                        )}
                                                </div>
                                                <Price
                                                    className={b('tariffPrice')}
                                                    price={convertPrice(
                                                        price,
                                                        currencies,
                                                    )}
                                                    round={false}
                                                />
                                            </li>
                                        ),
                                    )}
                            </ul>
                        </li>
                    ))}
            </ul>
        );
    }
}
