import {React, mix, B} from '../base';

import isEmpty from 'lodash/isEmpty';

import TariffsListBase from './TariffsListBase';

const b = B('TariffsList');

export default class TariffsList extends TariffsListBase {
    render(): React.ReactElement | null {
        const {className, viewMode, segment} = this.props;

        if (!segment.tariffs || isEmpty(segment.tariffs.classes)) {
            return null;
        }

        return (
            <ul className={mix(b({viewMode}), className)}>
                {this.getTariffsListItems(viewMode)}
            </ul>
        );
    }
}
