import {React, mix, B} from '../base';

import noop from '../../lib/noop';

import TariffsListBase from './TariffsListBase';

const b = B('TariffsList');

export default class TariffsList extends TariffsListBase {
    static defaultProps = {
        className: '',
        onClick: noop,
        tariffClassKeys: [],
    };

    render(): React.ReactElement {
        const {className, pageType} = this.props;

        return (
            <ul className={mix(b({pageType}), className)}>
                {this.getTariffsListItems(pageType)}
            </ul>
        );
    }
}
