import {PureComponent, React} from '../base';

import {TransportType} from '../../lib/transportType';
import ISegment from '../../interfaces/segment/ISegment';
import IStateCurrencies from '../../interfaces/state/IStateCurrencies';
import ISuburbanCategoryItem from '../../interfaces/segment/ISuburbanCategoryItem';
import ITransfer from '../../interfaces/transfer/ITransfer';
import ITransferSegment from '../../interfaces/transfer/ITransferSegment';

import TariffsListItem from '../TariffsListItem/TariffsListItem';

interface ITariffsListBaseProps {
    segment: ISegment | ITransfer | ITransferSegment;
    currencies: IStateCurrencies;

    tariffClassKeys?: string[];
    onClick?: Function;
    className?: string;
    pageType?: string;
    viewMode?: 'detailed';
}

export default class TariffsListBase extends PureComponent<
    ITariffsListBaseProps,
    {}
> {
    getTariffsListItems(pageType?: string): React.ReactElement[] | null {
        const {onClick, currencies, segment, tariffClassKeys, viewMode} =
            this.props;
        const {
            tariffs,
            transport: {code: transportType},
        } = segment;

        if (!tariffs) {
            return null;
        }

        const {suburbanCategories} = tariffs;

        if (transportType === TransportType.suburban && suburbanCategories) {
            const suburbanTariffsList = Object.values(
                suburbanCategories,
            ).reduce((result, category) => {
                category.forEach(tariff => {
                    if (tariff.isMain) {
                        result.push(tariff);
                    }
                });

                return result;
            }, [] as ISuburbanCategoryItem[]);

            if (suburbanTariffsList.length) {
                return suburbanTariffsList.map((tariff, index) => (
                    <TariffsListItem
                        key={`suburbanTariff${index}`}
                        onClick={onClick}
                        segment={segment}
                        tariffClass={tariff}
                        currencies={currencies}
                    />
                ));
            }
        }

        if (!tariffClassKeys) {
            return null;
        }

        return tariffClassKeys.map(classKey => (
            <TariffsListItem
                key={classKey}
                onClick={onClick}
                segment={segment}
                tariffClass={tariffs.classes[classKey]}
                classKey={classKey}
                currencies={currencies}
                pageType={pageType}
                viewMode={viewMode}
            />
        ));
    }
}
