import React, {memo, ReactElement, useState, useCallback} from 'react';
import B from 'bem-cn-lite';

import ITeaserFromApi from '../../interfaces/state/teasers/ITeaserFromApi';

// import Icon from '../Icon/Icon';
import Button from '../Button/Button';

import teasersKeyset from '../../i18n/teasers';

const b = B('Teaser');

interface ITeaser extends ITeaserFromApi {
    className?: string;
}

export default memo(Teaser);

function Teaser({
    type,
    title,
    content,
    mobileContent,

    className,
}: ITeaser): ReactElement | null {
    const [expanded, setExpanded] = useState(false);
    // const [hidden, setHidden] = useState(false);

    const onToggleDetails = useCallback(() => {
        setExpanded(!expanded);
    }, [expanded]);

    // const onClose = useCallback(() => {
    //     setHidden(true);
    // }, []);

    // if (hidden) {
    //     return null;
    // }

    const identicalContent = content === mobileContent || !mobileContent;
    const htmlContent = identicalContent
        ? content
        : expanded || !mobileContent
        ? content
        : mobileContent;

    return (
        <div className={b({[type]: true}, className)}>
            <div className={b('header')}>
                <span
                    className={b('title')}
                    dangerouslySetInnerHTML={{__html: title}}
                />
                {/* крестик снова появится в будущем, так что не удаляю насовсем */}
                {/* <Button className={b('closeButton')} onClick={onClose}>
                    <Icon className={b('closeIcon')} glyph="cross" />
                </Button> */}
            </div>

            <div
                className={b('content')}
                dangerouslySetInnerHTML={{__html: htmlContent}}
            />

            {!identicalContent && (
                <Button className={b('expandButton')} onClick={onToggleDetails}>
                    {teasersKeyset(expanded ? 'minimize' : 'details')}
                </Button>
            )}
        </div>
    );
}
