import {React, PureComponent, B, mix} from '../base';

const b = B('Teaser');

export default class Teaser extends PureComponent {
    render() {
        const {className, url, type, title, content, imageUrl} = this.props;

        return (
            <div className={mix(className, b({[type]: true}))}>
                <div className={b('title')}>
                    {url ? <a href={url}>{title}</a> : <span>{title}</span>}
                </div>

                <div className={b('content')}>
                    {imageUrl ? (
                        <img src={imageUrl} className={b('icon')} />
                    ) : null}

                    <div dangerouslySetInnerHTML={{__html: content}} />
                </div>
            </div>
        );
    }
}
