import React, {memo, ReactElement} from 'react';
import B from 'bem-cn-lite';

const b = B('TextSkeleton');

export interface ITextSkeletonProps {
    size?: 's' | 'm';
    width?: number;
    withAnimation?: boolean;
    className?: string;
}

export default memo(TextSkeleton);

function TextSkeleton({
    size = 's',
    width,
    withAnimation,
    className,
}: ITextSkeletonProps): ReactElement {
    return (
        <div className={b({size, withAnimation}, className)}>
            <div
                className={b('content')}
                style={{width: width ? `${width}px` : '100%'}}
            />
        </div>
    );
}
