import {React, B, PureComponent, PropTypes} from '../../base';

import {PROP_TYPES} from '../propTypes';

import noop from '../../../lib/noop';

import ThreadMap from '../ThreadMap';
import Modal from '../../basic/Modal';

export const b = B('ModalThreadMap');

export default class ModalThreadMap extends PureComponent {
    static propTypes = {
        mapData: PROP_TYPES.mapData.isRequired,
        transportType: PROP_TYPES.transportType,
        onClose: PropTypes.func,
        visible: PropTypes.bool,
    };

    static defaultProps = {
        onClose: noop,
        visible: false,
    };

    render() {
        const {mapData, visible, transportType, onClose} = this.props;

        return (
            <Modal
                className={b()}
                visible={visible}
                onClose={onClose}
                mods={{contentSize: 'big', paddings: 'small'}}
            >
                <div className={b('mapBlock')}>
                    <ThreadMap
                        mapData={mapData}
                        transportType={transportType}
                        id="thread-map"
                    />
                </div>
            </Modal>
        );
    }
}
