import {React, PureComponent, B, PropTypes} from '../../base';

import moment from 'moment';
import {connect} from 'react-redux';

import {CHAR_EM_DASH} from '../../../lib/stringUtils';
import {PROP_TYPES, DEFAULT_PROPS} from '../propTypes';

import getThreadUrl from '../../../lib/url/getThreadUrl';
import {reachGoal, reachGoalOnce} from '../../../lib/yaMetrika';

import Link from '../../Link';

import threadKeyset from '../../../i18n/thread';

const b = B('OtherTodayThreads');

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class OtherTodayThreads extends PureComponent {
    static propTypes = {
        otherTodayThreads: PROP_TYPES.otherTodayThreads.isRequired,
        canonicalUid: PROP_TYPES.canonicalUid,
        transportType: PROP_TYPES.transportType,
        stationFromId: PropTypes.number.isRequired,
        stationToId: PropTypes.number.isRequired,

        currentTimezone: PROP_TYPES.currentTimezone,
    };

    static defaultProps = {
        currentTimezone: DEFAULT_PROPS.currentTimezone,
    };

    componentDidMount() {
        const {transportType} = this.props;

        reachGoalOnce(`thread_${transportType}_other_today_thread_show`);
    }

    onLinkClick = () => {
        const {transportType} = this.props;

        reachGoal(`thread_${transportType}_other_today_thread_click`);
    };

    getThreadBlock(thread) {
        const {
            canonicalUid,
            stationFromId,
            stationToId,
            currentTimezone,
            tld,
            language,
        } = this.props;
        const {uid, title, departureDt, startDepartureTime, stopArrivalTime} =
            thread;

        return (
            <div className={b('threadBlock')}>
                <Link
                    className={b('threadLink')}
                    href={getThreadUrl({
                        tld,
                        language,
                        threadUid: uid,
                        canonicalUid,
                        stationToId,
                        stationFromId,
                        departureFromMoment: moment.parseZone(departureDt),
                        timezone: currentTimezone,
                    })}
                    onClick={this.onLinkClick}
                    key={uid}
                >
                    {title}
                </Link>
                <div className={b('times')}>
                    {`${startDepartureTime} ${CHAR_EM_DASH} ${stopArrivalTime}`}
                </div>
            </div>
        );
    }

    render() {
        const {otherTodayThreads} = this.props;

        return (
            <div className={b()}>
                <div className={b('title')}>
                    {threadKeyset('other-today-threads-title')}
                </div>
                {otherTodayThreads.map(thread => this.getThreadBlock(thread))}
            </div>
        );
    }
}

export default connect(mapStateToProps)(OtherTodayThreads);
