import {React, PureComponent, B} from '../../base';

import kebabCase from 'lodash/kebabCase';
import snakeCase from 'lodash/snakeCase';
import {connect} from 'react-redux';

import {RELATION_PRIORITY_ORDER} from '../../../lib/constants/threadsRelationTypes';
import {PROP_TYPES, DEFAULT_PROPS} from '../propTypes';

import getThreadUrl from '../../../lib/url/getThreadUrl';
import {reachGoal, reachGoalOnce} from '../../../lib/yaMetrika';

import Link from '../../Link';

import threadKeyset from '../../../i18n/thread';

const b = B('RelatedThreads');

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class RelatedThreads extends PureComponent {
    static propTypes = {
        relatedThreads: PROP_TYPES.relatedThreads.isRequired,
        transportType: PROP_TYPES.transportType,
        isNoChangeWagon: PROP_TYPES.isNoChangeWagon,

        currentTimezone: PROP_TYPES.currentTimezone,
    };

    static defaultProps = {
        currentTimezone: DEFAULT_PROPS.currentTimezone,
    };

    componentDidMount() {
        const {transportType, relatedThreads} = this.props;

        Object.keys(relatedThreads).forEach(relationType => {
            reachGoalOnce(
                `thread_${transportType}_${snakeCase(relationType)}_show`,
            );
        });
    }

    onLinkClick = e => {
        const {transportType} = this.props;
        const {
            currentTarget: {dataset},
        } = e;

        reachGoal(
            `thread_${transportType}_${snakeCase(dataset.relationType)}_click`,
        );
    };

    render() {
        const {relatedThreads, currentTimezone, tld, language} = this.props;

        return (
            <div className={b()}>
                {RELATION_PRIORITY_ORDER.map(
                    relationType =>
                        relatedThreads[relationType] && (
                            <div
                                className={b('relationBlock')}
                                key={relationType}
                            >
                                <div className={b('relationTitle')}>
                                    {threadKeyset(
                                        `related-threads-title-${kebabCase(
                                            relationType,
                                        )}`,
                                    )}
                                </div>
                                <div className={b('threadList')}>
                                    {relatedThreads[relationType].map(
                                        thread => (
                                            <Link
                                                className={b('threadLink')}
                                                href={getThreadUrl({
                                                    tld,
                                                    language,
                                                    canonicalUid:
                                                        thread.canonicalUid,
                                                    timezone: currentTimezone,
                                                })}
                                                onClick={this.onLinkClick}
                                                data-relation-type={
                                                    thread.relationType
                                                }
                                                key={thread.canonicalUid}
                                            >
                                                {thread.title}
                                            </Link>
                                        ),
                                    )}
                                </div>
                            </div>
                        ),
                )}
            </div>
        );
    }
}

export default connect(mapStateToProps)(RelatedThreads);
