import {PureComponent} from '../../base';

import Lang from '../../../interfaces/Lang';
import CurrencyCode from '../../../interfaces/CurrencyCode';

import {reachGoal} from '../../../lib/yaMetrika';
import {IWithClassName} from 'common/interfaces/components/IWithClassName';

interface ITariff {
    duration: number;
    offersCount: number;
    orderUrl: string;
    price: {value: number; currency: CurrencyCode};
    title: string;
}

interface ICurrencies {
    nationalCurrency: CurrencyCode;
    preferredCurrency: CurrencyCode;
    availableCurrencies: {code: CurrencyCode; rate: number; title: string}[];
    currencyRates: any;
}

interface IProps extends IWithClassName {
    querying: boolean;
    tariff: ITariff;
    allDaysCheckResult: boolean;
    allDaysCheckComplete: boolean;
    language: Lang;
    currencies: ICurrencies;
}

interface IState {}

export default class ThreadBlaBlaCar extends PureComponent<IProps, IState> {
    componentDidMount(): void {
        if (this.props.querying) {
            reachGoal('morda_blablacar_loading');
        } else {
            reachGoal('morda_blablacar_show');
        }
    }

    componentDidUpdate(oldProps): void {
        if (oldProps.querying && !this.props.querying) {
            reachGoal('morda_blablacar_show');
        }
    }

    onTitleClick(): void {
        reachGoal('morda_blablacar_service-link_click');
    }

    onOffersClick(): void {
        reachGoal('morda_blablacar_offers-link_click');
    }

    onSearchClick(): void {
        reachGoal('morda_blablacar_price_click');
    }
}
