import {React, B} from '../../base';
import ThreadBlaBlaCarBase from './base';
import moment from '../../../../reexports/moment-timezone';

import {ReactNode} from 'react';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import {humanizeDuration} from '../../../lib/date/formats';
import convertPrice from '../../../lib/currencies/convertPrice';

import Link from '../../Link';
import Icon from '../../Icon/Icon';
import Price from '../../Price/Price';
import Spinner from '../../Spinner/Spinner';

import keyset from '../../../i18n/blablacar';

const b = B('ThreadBlaBlaCar');

export default class ThreadBlaBlaCar extends ThreadBlaBlaCarBase {
    render(): ReactNode {
        const {
            tariff,
            querying,
            allDaysCheckResult,
            allDaysCheckComplete,

            className,
            currencies,
        } = this.props;

        const {price, orderUrl, duration, offersCount, title} = tariff;

        const noResultsOnDate = !offersCount && Boolean(allDaysCheckResult);
        const showPrice = Boolean(price && offersCount);

        const loaded =
            !querying && (Boolean(offersCount) || allDaysCheckComplete);

        const tenMinutes = 600;
        const roundedDuration = Math.ceil(duration / tenMinutes) * tenMinutes;
        const convertedPrice =
            price && currencies ? convertPrice(price, currencies) : price;

        return (
            <>
                <div className={b({loaded, noResultsOnDate}, className)}>
                    <div className={b('header')}>
                        <div className={b('description')}>
                            <div className={b('way')}>{title}</div>
                            {noResultsOnDate ? (
                                <div className={b('duration')}>
                                    <p className={b('noResultTopText')}>
                                        {keyset(
                                            'no-results-on-date-drivers-publicate',
                                        )}
                                    </p>
                                    <p className={b('noResultBottomText')}>
                                        {keyset(
                                            'no-results-on-date-add-notification',
                                        )}
                                    </p>
                                </div>
                            ) : (
                                <div className={b('duration')}>
                                    {`${humanizeDuration(
                                        moment.duration(
                                            roundedDuration,
                                            'seconds',
                                        ),
                                    )} ${keyset('in-way')},`}
                                </div>
                            )}
                            {!noResultsOnDate && (
                                <span className={b('phrase')}>
                                    {' '}
                                    {keyset('description').toLowerCase()}
                                </span>
                            )}
                        </div>
                        <Link
                            className={b('logo')}
                            rel="nofollow"
                            href={orderUrl}
                            target="_blank"
                            onClick={this.onTitleClick}
                        >
                            <Icon className={b('icon')} glyph={IconGlyph.bbc} />
                        </Link>
                    </div>
                    <div className={b('contentWrapper')}>
                        <div className={b('waiter')}>
                            <Spinner className={b('spinner')} size="small" />
                            <span className={b('waiterTitle')}>
                                {keyset('inProcess')}
                            </span>
                        </div>
                    </div>
                    <div className={b('footer')}>
                        {showPrice && (
                            <Link
                                className={b('offers')}
                                rel="nofollow"
                                href={orderUrl}
                                target="_blank"
                                onClick={this.onOffersClick}
                            >
                                <Price
                                    className={b('price')}
                                    price={convertedPrice}
                                    from
                                />
                                <div className={b('offers-amount')}>
                                    {keyset('offers', {count: offersCount})}
                                </div>
                            </Link>
                        )}
                        <Link
                            className={b('details')}
                            rel="nofollow"
                            href={orderUrl}
                            target="_blank"
                            onClick={this.onSearchClick}
                        >
                            {keyset('details')}
                        </Link>
                    </div>
                </div>
                <div className={b('advertise')}>{keyset('advertise')}</div>
            </>
        );
    }
}
