import React, {PureComponent} from 'react';
import B from 'bem-cn-lite';
import {PropTypes, mix} from '../../base';

import {momentTimezone as moment} from '../../../../reexports';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import {reachGoal, reachGoalOnce} from '../../../lib/yaMetrika';

import Duration from '../../Duration/Duration';
import Icon from '../../Icon/Icon';
import ThreadMap from '../ThreadMap';
import GlobalPopup from '../../GlobalPopup';
import ModalHistoryWrapper from '../../ModalHistoryWrapper/ModalHistoryWrapper';

import threadKeyset from '../../../i18n/thread';

const b = B('ThreadInfo');

export default class ThreadInfo extends PureComponent {
    static propTypes = {
        dateStart: PropTypes.instanceOf(moment).isRequired,
        dateStop: PropTypes.instanceOf(moment).isRequired,
        transportType: PropTypes.string.isRequired,

        mapData: PropTypes.object,
        className: PropTypes.string,
    };

    static defaultProps = {
        mapData: null,
        className: '',
    };

    state = {
        mapIsOpened: false,
    };

    componentDidMount() {
        const {mapData, transportType} = this.props;

        if (mapData) {
            reachGoalOnce(`thread_${transportType}_map_show`);
        }
    }

    onClickMapButton = () => {
        const {transportType} = this.props;

        this.setState({
            mapIsOpened: true,
        });

        reachGoal(`thread_${transportType}_map_click`);
    };

    onClose = () => this.onCloseMap();

    onCloseMap = () => {
        this.setState({
            mapIsOpened: false,
        });
    };

    getGlobalPopup() {
        const {mapData, transportType} = this.props;

        return (
            <ModalHistoryWrapper onClose={this.onCloseMap}>
                <GlobalPopup>
                    <div className={b('mapContainer')}>
                        <div
                            className={b('closeButton')}
                            onClick={this.onCloseMap}
                        >
                            <Icon
                                className={b('backIcon')}
                                glyph={IconGlyph.backArrow}
                            />
                            {threadKeyset('return-to-rasp')}
                        </div>
                        <div className={b('mapBlock')}>
                            <ThreadMap
                                mapData={mapData}
                                transportType={transportType}
                                id="thread-map"
                            />
                        </div>
                    </div>
                </GlobalPopup>
            </ModalHistoryWrapper>
        );
    }

    render() {
        const {dateStart, dateStop, className, mapData} = this.props;
        const {mapIsOpened} = this.state;

        return (
            <div className={mix(b(), className)}>
                <span className={b('inTheWay')}>
                    {threadKeyset('in-the-way')}{' '}
                    <Duration duration={dateStop - dateStart} />
                </span>
                {mapData && (
                    <div
                        className={b('mapButton')}
                        onClick={this.onClickMapButton}
                    >
                        <Icon
                            className={b('mapIcon')}
                            glyph={IconGlyph.mapIcon}
                        />
                        <span className={b('mapButtonText')}>
                            {threadKeyset('map-button')}
                        </span>
                    </div>
                )}
                {mapIsOpened && this.getGlobalPopup()}
            </div>
        );
    }
}
