/* eslint no-undef: 0 */
import B from 'bem-cn-lite';

import {TransportType} from '../../../lib/transportType';
import Platform from '../../../interfaces/Platform';

import getMinMaxCoords from '../../../lib/getMinMaxCoords';

import BasicMap from '../../BasicMap';

import mapKeyset from '../../../i18n/map';

const isMobile = process.env.PLATFORM !== Platform.desktop;
const colors = {
    [TransportType.bus]: '#ff7e00',
    [TransportType.water]: '#2195ec',
    [TransportType.suburban]: '#60b92d',
    [TransportType.train]: '#ff3726',
};
const glyphs = {
    [TransportType.bus]: 'pin-orange',
    [TransportType.water]: 'pin-blue',
    [TransportType.suburban]: 'pin-green',
    [TransportType.train]: 'pin-red',
};

export const b = B('ThreadMap');

function stopPropagation(e) {
    e.stopPropagation();
}

export default class ThreadMap extends BasicMap {
    className = b({isMobile});

    componentWillUnmount() {
        this.mapContainer.removeEventListener('click', stopPropagation);
    }

    addErrorMessage() {
        this.mapContainer.innerHTML = `<p class=${b(
            'mapErrorMessage',
        )}>${mapKeyset('error')}</p>`;
    }

    get mapContainer() {
        const {id} = this.props;

        return document.getElementById(id);
    }

    renderMap = () => {
        ymaps.ready(() => {
            const {mapData, transportType, id} = this.props;
            const {stations, segments} = mapData;
            const minMaxCoords = getMinMaxCoords(
                stations.map(station => station && station[0]),
            );

            if (!minMaxCoords) {
                return this.addErrorMessage();
            }

            const containerStyle = window.getComputedStyle(
                this.mapContainer,
                null,
            );

            const {center, zoom} = ymaps.util.bounds.getCenterAndZoom(
                minMaxCoords,
                [
                    parseInt(containerStyle.getPropertyValue('width'), 10),
                    parseInt(containerStyle.getPropertyValue('height'), 10),
                ],
            );
            const transportColor = colors[transportType];

            this.mapContainer.innerHTML = '';
            /* Не даем кликам по карте обрабатываться за её пределами
               Необходимо чтобы избежать непредведенного поведения различных внешних элементов */
            this.mapContainer.addEventListener('click', stopPropagation);

            this.mapObject = new ymaps.Map(
                id,
                {
                    center,
                    zoom,
                    controls: [
                        'zoomControl',
                        'trafficControl',
                        'geolocationControl',
                    ],
                },
                {
                    suppressMapOpenBlock: true,
                    autoFitToViewport: 'always',
                },
            );

            segments.forEach(segment => {
                const polyline = new ymaps.Polyline(
                    segment[0],
                    {},
                    {
                        strokeColor: transportColor,
                        strokeWidth: 4,
                    },
                );

                this.mapObject.geoObjects.add(polyline);
            });
            stations.forEach((station, index) => {
                const arrival = station[2]
                    ? `${mapKeyset('arrival')} ${station[2]}`
                    : '';
                const departure = station[3]
                    ? `${mapKeyset('departure')} ${station[3]}`
                    : '';
                const balloonContentBody =
                    arrival && departure
                        ? `${arrival} • ${departure}`
                        : arrival || departure;
                const balloonContent = {
                    balloonContentHeader: station[1],
                    balloonContentBody,
                };
                const firstOrLastStation =
                    index === 0 || index === stations.length - 1;
                const placemarkImageHref =
                    glyphs[transportType] + (firstOrLastStation ? '-big' : '');
                const iconImageSize = firstOrLastStation ? [12, 12] : [10, 10];

                const placemark = new ymaps.Placemark(
                    station[0],
                    {
                        ...balloonContent,
                    },
                    {
                        // preset: 'islands#circleIcon',
                        // iconColor: transportColor,
                        iconLayout: 'default#image',
                        // Своё изображение иконки метки.
                        iconImageHref: `${process.env.IMAGES_PATH}/mapPoints/${placemarkImageHref}.svg`,
                        iconImageOffset: [-5, -5],
                        // Размеры метки.
                        iconImageSize,
                        hideIconOnBalloonOpen: false,
                        balloonMaxWidth: window.innerWidth * 0.6,
                    },
                );

                this.mapObject.geoObjects.add(placemark);
            });
        });
    };
}
