import React, {memo, ReactElement, useMemo} from 'react';
import B from 'bem-cn-lite';

import useSelector from '../../useSelector';
import {useFlags} from '../../../hooks/useFlags';

import ThreadPrices from '../ThreadPrices/ThreadPrices.mobile';
import RidesharingSegment from '../../../components/RidesharingSegment';

const b = B('ThreadPriceConainer');

interface IThreadPriceConainerProps {
    priceClassName?: string;
}

export default memo(ThreadPriceConainer);

function ThreadPriceConainer({
    priceClassName,
}: IThreadPriceConainerProps): ReactElement | null {
    const flags = useFlags();
    const thread = useSelector(state => state.thread);
    const currencies = useSelector(state => state.currencies);
    const language = useSelector(state => state.language);

    const {segment, priceQuerying, blablacar} = thread;

    const {banned, querying, tariff, allDaysCheckComplete, allDaysCheckResult} =
        blablacar || {};

    const blaBlaCarIsAvailable =
        !banned &&
        (querying ||
            (tariff && tariff.offersCount) ||
            !allDaysCheckComplete ||
            allDaysCheckResult !== null);

    const blaBlaCar = useMemo(() => {
        if (!blaBlaCarIsAvailable) {
            return null;
        }

        return (
            <RidesharingSegment
                className={b('ridesharing')}
                querying={querying}
                tariff={tariff}
                allDaysCheckResult={allDaysCheckResult}
                allDaysCheckComplete={allDaysCheckComplete}
                currencies={currencies}
                language={language}
                flags={flags}
            />
        );
    }, [
        blaBlaCarIsAvailable,
        querying,
        tariff,
        allDaysCheckResult,
        allDaysCheckComplete,
        currencies,
        language,
        flags,
    ]);

    const showThreadPrices = segment || priceQuerying;

    const showBlaBlaCar = blaBlaCarIsAvailable && !showThreadPrices;

    return (
        <div className={b()}>
            {showThreadPrices && <ThreadPrices className={priceClassName} />}

            {showBlaBlaCar && (
                <div className={b('ridesharingContainer')}>{blaBlaCar}</div>
            )}
        </div>
    );
}
