import {Moment} from 'moment';

import Tld from '../../../interfaces/Tld';
import Lang from '../../../interfaces/Lang';
import ICapital from '../../../interfaces/ICapital';
import {TransportType} from '../../../lib/transportType';
import IStation from '../../../interfaces/state/thread/IStation';
import IStationCountry from '../../../interfaces/state/thread/IStationCountry';

/* Список всех возможных колонок */
export enum ThreadTableColumnName {
    station = 'station',
    arrival = 'arrival',
    stay = 'stay',
    departure = 'departure',
    intervalInfo = 'intervalInfo',
    timeInTheWay = 'timeInTheWay',
}

/* Список всех возможных типов строк */
export enum ThreadTableRowType {
    subtitle = 'subtitle',
    station = 'station',
    transition = 'transition',
}

export enum ThreadType {
    prev = 'prev',
    current = 'current',
    next = 'next',
}

export interface ISubtitleTableRow {
    type: ThreadTableRowType.subtitle;
    thread: ThreadType;
    colspan: number;
    stationDate?: Moment;
    country?: IStationCountry;
    capitalTimeOffset?: string;
}

export interface IStationTableRow {
    type: ThreadTableRowType.station;
    thread: ThreadType;
    station: IStation;
    arrivalDate?: Moment;
    departureDate?: Moment;
}

export interface ITransitionTableRow {
    type: ThreadTableRowType.transition;
    thread: ThreadType;
    colspan: number;
    transitionTime: number;
}

export type TTableRowContent =
    | ISubtitleTableRow
    | IStationTableRow
    | ITransitionTableRow;

interface ICommonGetRowParams {
    index: number;
}

export interface IGetSubtitleRowParams extends ICommonGetRowParams {
    row: ISubtitleTableRow;
    capitals: ICapital[];
    capitalSlug: string;
}

export interface IGetStationRowParams extends ICommonGetRowParams {
    row: IStationTableRow;
    startDateOfThread: Moment | '';
    stationFromData: IStation;
    stationToData: IStation;
    beginTime: string;
    endTime: string;
    density: string;
    comment: string;
    transportType: TransportType;
    isSuburbanBus: boolean;
    isIntervalThread: boolean;
    tld: Tld;
    language: Lang;
    onClickRowStation: any;
    onClickStationName: any;
    stations: IStation[];

    displayIntervalThreadInfo?: boolean;
    isFullCanceling?: boolean;
}

export interface IGetTransitionRowParams extends ICommonGetRowParams {
    row: ITransitionTableRow;
}

export type TGetRowParams =
    | IGetSubtitleRowParams
    | IGetStationRowParams
    | IGetTransitionRowParams;

export function isSubtitleTableRow(
    row: TTableRowContent,
): row is ISubtitleTableRow {
    return row.type === ThreadTableRowType.subtitle;
}

export function isSubtitleTableRowParams(
    params: TGetRowParams,
): params is IGetSubtitleRowParams {
    return isSubtitleTableRow(params.row);
}

export function isStationTableRow(
    row: TTableRowContent,
): row is IStationTableRow {
    return row.type === ThreadTableRowType.station;
}

export function isStationTableRowParams(
    params: TGetRowParams,
): params is IGetStationRowParams {
    return isStationTableRow(params.row);
}

export function isTransitionTableRow(
    row: TTableRowContent,
): row is ITransitionTableRow {
    return row.type === ThreadTableRowType.transition;
}

export function isTransitionTableRowParams(
    params: TGetRowParams,
): params is IGetTransitionRowParams {
    return isTransitionTableRow(params.row);
}
