import {PropTypes} from '../base';

export const PROP_TYPES_CAPITAL = PropTypes.shape({
    timezone: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,

    titleGenitive: PropTypes.string,
    abbrTitle: PropTypes.string,
});

export const OTHER_TODAY_THREADS = PropTypes.arrayOf(
    PropTypes.shape({
        uid: PropTypes.string.isRequired,
        title: PropTypes.string.isRequired,
        startDepartureTime: PropTypes.string.isRequired,
        stopArrivalTime: PropTypes.string.isRequired,
        departureDt: PropTypes.string.isRequired,
    }),
);

export const PROP_TYPES = {
    id: PropTypes.string.isRequired,
    canonicalUid: PropTypes.string.isRequired,
    stations: PropTypes.arrayOf(PropTypes.object).isRequired,
    title: PropTypes.string.isRequired,
    transportType: PropTypes.string.isRequired,
    company: PropTypes.object.isRequired,
    runDays: PropTypes.object.isRequired,
    runDaysText: PropTypes.string.isRequired,
    page: PropTypes.object.isRequired,
    prevStationsIsOpened: PropTypes.bool.isRequired,
    nextStationsIsOpened: PropTypes.bool.isRequired,
    calendarIsOpened: PropTypes.bool.isRequired,
    isIntervalThread: PropTypes.bool.isRequired,
    isSuburbanBus: PropTypes.bool.isRequired,
    isNoChangeWagon: PropTypes.bool.isRequired,
    beginTime: PropTypes.string.isRequired,
    endTime: PropTypes.string.isRequired,
    density: PropTypes.string.isRequired,
    comment: PropTypes.string.isRequired,
    currencies: PropTypes.object.isRequired,
    priceQuerying: PropTypes.bool.isRequired,
    capitalSlug: PropTypes.string.isRequired,
    capitals: PropTypes.arrayOf(PROP_TYPES_CAPITAL),
    fromStationDepartureLocalDt: PropTypes.string.isRequired,

    departure: PropTypes.string,
    departureFrom: PropTypes.string,
    stationFrom: PropTypes.string,
    stationTo: PropTypes.string,
    mapData: PropTypes.object,
    mapIsOpened: PropTypes.bool,
    segment: PropTypes.object,
    currentTimezone: PropTypes.string,
    threads: PropTypes.object,
    otherTodayThreads: OTHER_TODAY_THREADS,
    relatedThreads: PropTypes.object,
};

export const DEFAULT_PROPS = {
    departure: '',
    departureFrom: '',
    stationFrom: '',
    stationTo: '',
    mapData: null,
    mapIsOpened: false,
    segment: null,
    currentTimezone: '',
    threads: null,
    otherTodayThreads: [],
    relatedThreads: null,
};
