import React from 'react';
import {Moment} from 'moment';

import CalendarDayLink from '../CalendarDayLink';

interface IThreadPageCalendarDayLinkProps {
    day: Moment;
    today: Moment;
    getDataForDayComponent(day: Moment): {
        link: string;
        type?: string;
        current: boolean;
    };

    dateStart?: Moment;
    onClick?(): void;
}

const isMobile = process.env.PLATFORM !== 'desktop';

const ThreadPageCalendarDayLink: React.FC<IThreadPageCalendarDayLinkProps> =
    props => {
        const {day, today, onClick, getDataForDayComponent, dateStart} = props;
        const {link, type, current} = getDataForDayComponent(day);

        return (
            <CalendarDayLink
                day={day}
                today={today}
                href={link || null}
                dateStart={isMobile ? undefined : dateStart}
                type={current ? `${type}Current` : type}
                colorless={day.isBefore(today, 'day')}
                onClick={onClick}
            />
        );
    };

export default ThreadPageCalendarDayLink;
