import {React, Component, mix} from '../base';

import {TIME} from '../../lib/date/formats';

import commonKeyset from '../../i18n/common';

const b = 'Time';

export default class Time extends Component {
    render() {
        const {timeMoment, isFuzzy, className} = this.props;

        const format = `${isFuzzy ? '~' : ''}${this.props.format}`;

        return (
            <span className={mix(b, className)}>
                {timeMoment.isValid()
                    ? timeMoment.format(format)
                    : this.props.format === TIME
                    ? commonKeyset('no-data')
                    : null}
            </span>
        );
    }
}

Time.defaultProps = {
    format: TIME,
};
