import {React, B, PureComponent} from '../base';

import {connect} from 'react-redux';

import {YANDEX_BROWSER} from '../../lib/constants/browsers';

import IconGlyph from '../../interfaces/components/IconGlyph';

import Icon from '../Icon/Icon';

const b = B('ToTheTop');

const minDisplayCoord = 250;

const mapStateToProps = ({user}) => ({user});

class ToTheTop extends PureComponent {
    constructor(props) {
        super(props);

        this.state = {
            visible: false,
            disabled: props.user.browser.name === YANDEX_BROWSER,
        };
    }

    componentDidMount() {
        if (!this.state.disabled) {
            window.addEventListener('scroll', this.setToTheTopVisibility);
            this.setToTheTopVisibility();
        }
    }

    componentWillUnmount() {
        window.removeEventListener('scroll', this.setToTheTopVisibility);
    }

    onClickToTheTop() {
        window.scrollTo(0, 0);
    }

    setToTheTopVisibility = () => {
        if (window.pageYOffset > minDisplayCoord) {
            this.setState({visible: true});
        } else {
            this.setState({visible: false});
        }
    };

    render() {
        const {visible, disabled} = this.state;
        const {className} = this.props;

        if (disabled || !visible) {
            return null;
        }

        return (
            <button className={b({}, className)} onClick={this.onClickToTheTop}>
                <Icon className={b('arrow')} glyph={IconGlyph.swapArrow} />
            </button>
        );
    }
}

export default connect(mapStateToProps)(ToTheTop);
