import {React, PureComponent, B, bindMethods} from '../base';

import Popup from '../Popup/Popup';

const b = B('Tooltip');

export default class Tooltip extends PureComponent {
    constructor(props) {
        super(props);
        this.state = {fixed: false};
        bindMethods(this, ['onClick', 'onMouseEnter', 'onMouseLeave']);
    }

    onMouseEnter() {
        this.setFixed(true);
    }

    onMouseLeave() {
        this.setFixed(false);
    }

    onClick() {
        this.setFixed(false);
    }

    setFixed(fixed) {
        this.setState({fixed});
    }

    render() {
        const {visible, content, position} = this.props;
        const {fixed} = this.state;
        const style = {
            top: `${position.top}px`,
            left: `${position.left}px`,
        };

        return (
            <Popup style={style} className={b()} visible={visible || fixed}>
                <div
                    className={b('content')}
                    onClick={this.onClick}
                    onMouseEnter={this.onMouseEnter}
                    onMouseLeave={this.onMouseLeave}
                    dangerouslySetInnerHTML={{__html: content}}
                />
            </Popup>
        );
    }
}
