import {React, PureComponent, PropTypes, mix, B} from '../../base';

import {PAGE} from '../propTypes';

import Article from '../../Article/Article';

const b = B('TransportCityArticles');

const isMobile = process.env.PLATFORM === 'mobile';

export default class TransportCityArticles extends PureComponent {
    static propTypes = {
        articles: PAGE.articles,
        className: PropTypes.string,
    };

    static defaultProps = {
        className: '',
    };

    render() {
        const {articles, className} = this.props;

        return (
            <div className={mix(b(), className)}>
                {articles.map(article => (
                    <Article
                        {...article}
                        key={article.slug}
                        mods={{withSeparator: !isMobile}}
                    />
                ))}
            </div>
        );
    }
}
