import {React, PureComponent, PropTypes, mix, B} from '../../base';

import {connect} from 'react-redux';

import {PAGE} from '../propTypes';
import {CHAR_EM_DASH} from '../../../lib/stringUtils';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import {getCanonicalUrl} from '../../../lib/url/searchUrl';

import Link from '../../Link';
import Icon from '../../Icon/Icon';

import keyset from '../../../i18n/transport-city';

const b = B('TransportCityPopularDirections');

const isMobile = process.env.PLATFORM === 'mobile';

const mapStateToProps = ({language, tld}) => ({
    language,
    tld,
});

class TransportCityPopularDirections extends PureComponent {
    static propTypes = {
        popularDirections: PAGE.popularDirections,
        transportType: PAGE.transportType,
        className: PropTypes.string,
    };

    static defaultProps = {
        className: '',
    };

    render() {
        const {popularDirections, transportType, language, tld, className} =
            this.props;

        return (
            <div className={mix(b({isMobile}), className)}>
                <div className={b('content')}>
                    <div className={b('title')}>
                        <Icon
                            className={b('icon', {transportType})}
                            glyph={IconGlyph.pointIcon}
                        />
                        <span className={b('titleText')}>
                            {keyset('popular-directions')}
                        </span>
                    </div>
                    <div className={b('list')}>
                        {popularDirections.map(popularDirection => (
                            <div
                                key={`${popularDirection.from.key}_${popularDirection.to.key}`}
                            >
                                <Link
                                    className={b('link')}
                                    href={getCanonicalUrl(
                                        {
                                            canonical: {
                                                transportType,
                                                pointFrom:
                                                    popularDirection.from.slug,
                                                pointTo:
                                                    popularDirection.to.slug,
                                            },
                                            transportType,
                                            language,
                                        },
                                        tld,
                                        language,
                                    )}
                                >
                                    {popularDirection.from.title}
                                    {` ${CHAR_EM_DASH} `}
                                    {popularDirection.to.title}
                                </Link>
                            </div>
                        ))}
                    </div>
                </div>
            </div>
        );
    }
}

export default connect(mapStateToProps)(TransportCityPopularDirections);
