import {React, PureComponent, PropTypes, mix, B} from '../../base';

import {connect} from 'react-redux';

import {PAGE} from '../propTypes';
import {SUBURBAN_TYPE} from '../../../lib/transportType';

import {stationUrl} from '../../../lib/url/stationUrl';
import getSubtypeByTransportType from '../../../lib/station/getSubtypeByTransportType';

import Link from '../../Link';

import keyset from '../../../i18n/transport-city';

const b = B('TransportCityStations');

const isMobile = process.env.PLATFORM === 'mobile';

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class TransportCityStations extends PureComponent {
    static propTypes = {
        transportType: PAGE.transportType,
        settlement: PAGE.settlement,
        stations: PAGE.stations,
        className: PropTypes.string,
    };

    static defaultProps = {
        className: '',
    };

    render() {
        const {
            transportType,
            settlement: {title, titleGenitive},
            stations,
            className,
            tld,
            language,
        } = this.props;

        const bannerHref = `${process.env.IMAGES_PATH}/transportCityBanners/${transportType}.jpg`;
        const linearGradient =
            'linear-gradient(to top,' +
            'rgba(0,0,0,.7) 0%,' +
            `rgba(0,0,0,0) ${
                transportType === SUBURBAN_TYPE ? '75%' : '50%'
            },` +
            'rgba(0,0,0,0) 100%)';

        return (
            <div className={mix(b({isMobile}), className)}>
                <div className={b('wrapper')}>
                    <div
                        className={b('banner', {transportType})}
                        style={{
                            background: `${linearGradient}, url(${bannerHref}), #777`,
                            backgroundSize: 'cover',
                        }}
                    >
                        <div className={b('bannerText')}>
                            {keyset(`banner-${transportType}`, {
                                titleGenitive: titleGenitive || title,
                            })}
                        </div>
                    </div>
                    <div className={b('content')}>
                        <div className={b('title')}>
                            {keyset(`stations-${transportType}`, {
                                titleGenitive: titleGenitive || title,
                            })}
                        </div>
                        <div className={b('list')}>
                            {stations.map(station => (
                                <div
                                    key={station.id}
                                    className={b('linkWrapper')}
                                >
                                    <Link
                                        className={b('link')}
                                        href={stationUrl({
                                            id: station.id,
                                            pageType: station.pageType,
                                            mainSubtype: station.mainSubtype,
                                            subtype:
                                                getSubtypeByTransportType(
                                                    transportType,
                                                ),
                                            isMobile,
                                            tld,
                                            language,
                                        })}
                                    >
                                        {station.title}
                                    </Link>
                                </div>
                            ))}
                        </div>
                    </div>
                </div>
            </div>
        );
    }
}

export default connect(mapStateToProps)(TransportCityStations);
