import {React, PureComponent, B} from '../base';

import {PAGE} from './propTypes';

import LoadingChunk from '../basic/LoadingChunk';
import TransportCityStations from './TransportCityStations';
import TransportCityPopularDirections from './TransportCityPopularDirections';
import TransportCityArticles from './TransportCityArticles';

const b = B('TransportCityPage');

export default class TransportCityPage extends PureComponent {
    static propTypes = PAGE;

    renderLoading() {
        return <LoadingChunk />;
    }

    render() {
        const {
            transportType,
            settlement,
            directions,
            stations,
            popularDirections,
            articles,
            page,
        } = this.props;

        if (page.fetching) {
            return this.renderLoading();
        }

        const hasPopularDirections =
            popularDirections && popularDirections.length > 0;
        const hasArticles = articles && articles.length > 0;

        return (
            <div className={b()}>
                <TransportCityStations
                    className={b('block')}
                    transportType={transportType}
                    settlement={settlement}
                    directions={directions}
                    stations={stations}
                />
                {hasPopularDirections && (
                    <TransportCityPopularDirections
                        className={b('block')}
                        popularDirections={popularDirections}
                        transportType={transportType}
                    />
                )}
                {hasArticles && (
                    <TransportCityArticles
                        className={b('articles')}
                        articles={articles}
                    />
                )}
            </div>
        );
    }
}
