import {PropTypes} from '../base';

export const SETTLEMENT = {
    slug: PropTypes.string.isRequired,
    title: PropTypes.string.isRequired,
    titleGenitive: PropTypes.string,
};

export const SETTLEMENT_DEFAULT = {
    titleGenitive: '',
};

export const STATION = {
    title: PropTypes.string.isRequired,
    id: PropTypes.number.isRequired,
};

export const STATION_OF_POPULAR_DIRECTION = {
    title: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,
    key: PropTypes.string.isRequired,
};

export const POPULAR_DIRECTION = {
    from: PropTypes.shape(STATION_OF_POPULAR_DIRECTION).isRequired,
    to: PropTypes.shape(STATION_OF_POPULAR_DIRECTION).isRequired,
};

export const ARTICLE = {
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,
};

export const PAGE = {
    transportType: PropTypes.string.isRequired,
    settlement: PropTypes.shape(SETTLEMENT).isRequired,
    stations: PropTypes.arrayOf(PropTypes.shape(STATION)).isRequired,
    popularDirections: PropTypes.arrayOf(PropTypes.shape(POPULAR_DIRECTION))
        .isRequired,
    articles: PropTypes.arrayOf(PropTypes.shape(ARTICLE)).isRequired,
    page: PropTypes.object.isRequired,
};
