import {React, B} from '../base';

import {TransportType} from '../../lib/transportType';
import IconGlyph from '../../interfaces/components/IconGlyph';

import Icon from '../Icon/Icon';

import segmentKeyset from '../../i18n/segment';
import transportTypeKeyset from '../../i18n/transport-types';

export const glyphsByTransportType = {
    bus: IconGlyph.bus,
    train: IconGlyph.train,
    plane: IconGlyph.plane,
    helicopter: IconGlyph.helicopter,
    suburban: IconGlyph.suburban,
    water: IconGlyph.water,
};

const b = B('TransportIcon');

interface ITransportIcon {
    transportType: TransportType;

    className?: string;
    title?: string;
    showHint?: boolean;
    isExpress?: boolean;
    isAeroExpress?: boolean;
    colored?: boolean;
    size?: 'huge' | 'giant' | 'medium';
}

export default React.memo(TransportIcon);

function TransportIcon({
    transportType,
    className = '',
    title = '',
    showHint = true,
    isExpress = false,
    isAeroExpress = false,
    colored = true,
    size,
}: ITransportIcon): React.ReactElement {
    const ariaLabel =
        title ||
        (isExpress && segmentKeyset('express')) ||
        (isAeroExpress && segmentKeyset('aeroexpress')) ||
        transportTypeKeyset.get(`type-${transportType}`);

    return (
        <figure
            className={b(
                {
                    showHint,
                    type: transportType,
                    isExpress: isExpress || isAeroExpress,
                    colored,
                    size,
                },
                className,
            )}
            aria-label={ariaLabel}
        >
            <Icon
                className={b('icon')}
                glyph={glyphsByTransportType[transportType]}
            />
        </figure>
    );
}
