import React, {ReactElement, memo} from 'react';
import B from 'bem-cn-lite';

import {TransportType} from '../../lib/transportType';
import IconGlyph from '../../interfaces/components/IconGlyph';

import Icon from '../Icon/Icon';

const b = B('TransportIconInCircle');

const glyphByTransportType = {
    [TransportType.train]: IconGlyph.railroad,
    [TransportType.suburban]: IconGlyph.railroad,
    [TransportType.bus]: IconGlyph.bus2,
    [TransportType.plane]: IconGlyph.plane2,
    [TransportType.water]: IconGlyph.water2,
};

interface ITransportIconInCircle {
    transportType: TransportType;

    className?: string;
}

export default memo(TransportIconInCircle);

function TransportIconInCircle({
    transportType,

    className,
}: ITransportIconInCircle): ReactElement {
    const glyph = glyphByTransportType[transportType];

    return (
        <div className={b({glyph}, className)}>
            {glyph && <Icon glyph={glyph} className={b('icon')} />}
        </div>
    );
}
