import {React, PureComponent, PropTypes, mix, B} from '../../base';

import {PAGE} from '../propTypes';

import {getFlagUrl} from '../../../lib/flagsUrl';

import Link from '../../Link';

import keyset from '../../../i18n/transport';

const b = B('TransportCountries');

const isMobile = process.env.PLATFORM === 'mobile';

export default class TransportCountries extends PureComponent {
    static propTypes = {
        className: PropTypes.string,
        countries: PAGE.countries,
        transportType: PAGE.transportType,
    };

    static defaultProps = {
        className: '',
    };

    render() {
        const {countries, transportType, className} = this.props;

        return (
            <div className={mix(b({isMobile}), className)}>
                <div className={b('title')}>
                    {keyset(`country-${transportType}`)}
                </div>
                <div className={b('list')}>
                    {countries.map(country => (
                        <Link key={country.title} className={b('country')}>
                            <img
                                src={getFlagUrl(country.code.toLowerCase())}
                                className={b('icon')}
                            />
                            {country.title}
                        </Link>
                    ))}
                </div>
            </div>
        );
    }
}
