import {React, PureComponent, B} from '../base';

import {PAGE} from './propTypes';

import LoadingChunk from '../basic/LoadingChunk';
import TransportCity from './TransportCity';
import TransportCities from './TransportCities';
import TransportArticles from './TransportArticles';
import TransportCountries from './TransportCountries';

import keyset from '../../i18n/transport';

const b = B('TransportPage');

// пока не показываем страны
const showCountries = false;

export default class TransportPage extends PureComponent {
    static propTypes = PAGE;

    renderLoading() {
        return <LoadingChunk />;
    }

    render() {
        const {
            page,
            cities,
            articles,
            mainCity,
            countries,
            secondaryCity,
            transportType,
        } = this.props;

        if (page.fetching) {
            return this.renderLoading();
        }

        const hasMainCity = mainCity && mainCity.stations.length > 0;
        const hasSecondaryCity =
            secondaryCity && secondaryCity.stations.length > 0;
        const hasArticles = articles && articles.length > 0;
        const hasCountries = countries && countries.length > 0;
        const hasCities = cities && cities.length > 0;

        const bannerHref = `${process.env.IMAGES_PATH}/transportBannersMobile/${transportType}.jpg`;
        const linearGradient = `
                linear-gradient(
                    to bottom,
                    rgba(0, 0, 0, 0) 0%,
                    rgba(0, 0, 0, 0.7) 100%
                )
            `;
        const bannerStyle = {
            background: `${linearGradient}, url(${bannerHref}), #777`,
            backgroundSize: 'cover',
            backgroundPositionY: 'center',
        };

        return (
            <div className={b()}>
                <div className={b('content')}>
                    <div
                        style={bannerStyle}
                        className={b('banner', {transportType})}
                    >
                        <div className={b('bannerText')}>
                            {keyset(`banner-${transportType}`)}
                        </div>
                    </div>
                    <div className={b('main')}>
                        {hasMainCity && (
                            <TransportCity
                                className={b('city')}
                                city={mainCity}
                                transportType={transportType}
                            />
                        )}
                        {hasSecondaryCity && (
                            <TransportCity
                                className={b('secondaryCity')}
                                city={secondaryCity}
                                mods={{withListSeparator: true}}
                                transportType={transportType}
                            />
                        )}
                        {hasCities && (
                            <TransportCities
                                className={b('cities')}
                                cities={cities}
                                transportType={transportType}
                            />
                        )}
                        {showCountries && hasCountries && (
                            <TransportCountries
                                className={b('countries')}
                                countries={countries}
                                transportType={transportType}
                            />
                        )}
                    </div>
                </div>
                {hasArticles && (
                    <TransportArticles
                        className={b('articles')}
                        articles={articles}
                    />
                )}
            </div>
        );
    }
}
