import {PropTypes} from '../base';

export const STATION = {
    title: PropTypes.string.isRequired,
    id: PropTypes.number.isRequired,
};

export const MAIN_CITY = {
    title: PropTypes.string.isRequired,
    titleGenitive: PropTypes.string,
    slug: PropTypes.string,
    stations: PropTypes.arrayOf(PropTypes.shape(STATION)).isRequired,
};

export const SECONDARY_CITY = {
    title: PropTypes.string.isRequired,
    titleGenitive: PropTypes.string,
    slug: PropTypes.string,
    stations: PropTypes.arrayOf(PropTypes.shape(STATION)).isRequired,
};

export const STATION_OF_POPULAR_DIRECTION = {
    title: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,
    key: PropTypes.string.isRequired,
};

export const POPULAR_DIRECTION = {
    from: PropTypes.shape(STATION_OF_POPULAR_DIRECTION).isRequired,
    to: PropTypes.shape(STATION_OF_POPULAR_DIRECTION).isRequired,
};

export const ARTICLE = {
    title: PropTypes.string.isRequired,
    description: PropTypes.string.isRequired,
    slug: PropTypes.string.isRequired,
};

export const CITIES = {
    title: PropTypes.string.isRequired,
    slug: PropTypes.string,
    stationId: PropTypes.number,
};

export const COUNTRIES = {
    title: PropTypes.string.isRequired,
    code: PropTypes.string.isRequired,
    titleGenitive: PropTypes.string,
};

export const PAGE = {
    transportType: PropTypes.string.isRequired,
    mainCity: PropTypes.shape(MAIN_CITY).isRequired,
    popularDirections: PropTypes.arrayOf(PropTypes.shape(POPULAR_DIRECTION))
        .isRequired,
    articles: PropTypes.arrayOf(PropTypes.shape(ARTICLE)).isRequired,
    cities: PropTypes.arrayOf(PropTypes.shape(CITIES)).isRequired,
    countries: PropTypes.arrayOf(PropTypes.shape(COUNTRIES)).isRequired,
    secondaryCity: PropTypes.shape(SECONDARY_CITY),
    page: PropTypes.object.isRequired,
};
