import {React, PureComponent, bindMethods, B} from '../base';

import capitalize from 'lodash/capitalize';

import {reachGoal} from '../../lib/yaMetrika';
import {setTransportTypeFromUser} from '../../actions/searchForm';
import {SEARCHABLE_TRANSPORT_TYPES} from '../../lib/transportType';

import RadioGroup from '../basic/RadioGroup';

import keyset from '../../i18n/transport-types';

const b = B('TransportSelector');

export default class TransportSelector extends PureComponent {
    constructor(props) {
        super(props);
        bindMethods(this, ['onChange']);
    }

    onChange(e, data) {
        this.props.dispatch(setTransportTypeFromUser(data.value));
        reachGoal('search_transport_click');
    }

    render() {
        const {value, noAnimation} = this.props;

        const transportTypeButtons = SEARCHABLE_TRANSPORT_TYPES.map(code => ({
            value: code,
            label: capitalize(keyset(`type-${code}`)),
        }));

        return (
            <div className={b({noAnimation})}>
                <RadioGroup
                    name="transportType"
                    value={value}
                    buttons={transportTypeButtons}
                    onChange={this.onChange}
                />
            </div>
        );
    }
}
