import React, {PureComponent} from 'react';
import {connect} from 'react-redux';
import B from 'bem-cn-lite';

import {SEARCHABLE_TRANSPORT_TYPES} from '../../lib/transportType';

import searchUrl from '../../lib/url/searchUrl';
import {reachGoal} from '../../lib/yaMetrika';

import Link from '../Link';

import transportTypesKeyset from '../../i18n/transport-types';
import transportSelectorKeyset from '../../i18n/transport-selector';

const b = B('TransportSelectorLinks');

const mapStateToProps = ({tld, language}) => ({
    tld,
    language,
});

class TransportSelectorLinks extends PureComponent {
    onClick(e) {
        reachGoal('TRANSPORT_SELECTOR_LINK_CLICK', {
            type: e.target.dataset.code,
        });
    }

    render() {
        const {sort, context, className, filtering, currencies, tld, language} =
            this.props;
        const {transportType: currentValue, userInput} = context;
        const {from, to} = userInput || context;

        const transportTypeLinks = SEARCHABLE_TRANSPORT_TYPES.map(code => ({
            value: code,
            label: transportTypesKeyset(
                code === 'all' ? 'type-all-long' : `type-${code}`,
            ),
            title: transportSelectorKeyset(`title-${code}`, {
                from: from.title,
                to: to.title,
            }),
            url: searchUrl(
                {
                    context: {
                        ...context,
                        transportType: code,
                    },
                    sort,
                    filtering,
                    currencies,
                },
                tld,
                language,
            ),
        }));

        return (
            <div className={b({}, className)}>
                {transportTypeLinks.map((item, index) =>
                    item.value === currentValue ? (
                        <span key={index} className={b('selectedTransport')}>
                            {item.label}
                        </span>
                    ) : (
                        <Link
                            key={index}
                            href={item.url}
                            title={item.title}
                            data-code={item.value}
                            onClick={this.onClick}
                            className={b('item')}
                        >
                            {item.label}
                        </Link>
                    ),
                )}
            </div>
        );
    }
}

export default connect(mapStateToProps)(TransportSelectorLinks);
