import React, {FunctionComponent} from 'react';
import B from 'bem-cn-lite';

import {getHotelRegionUrl} from '../../lib/url/getHotelRegionUrl';
import {getHotelSearchUrl} from '../../lib/url/getHotelSearchUrl';

import useSelector from '../useSelector';

import {IHotelsBannerInfo} from 'common/interfaces/state/search/BannerInfo';
import {IWithClassName} from 'common/interfaces/components/IWithClassName';

import Link from '../Link';

import keyset from '../../../common/i18n/hotels-banner';

const b = B('TravelHotelsBanner');

interface ITravelHotelsBannerProps extends IWithClassName {
    bannerInfo: IHotelsBannerInfo;
}

const TravelHotelsBanner: FunctionComponent<ITravelHotelsBannerProps> = ({
    className,
    bannerInfo,
}) => {
    const {data} = bannerInfo;
    const {region, slug, geoId, checkinDate, doesLandingExist} = data;
    const isProduction = useSelector(state => state.environment.production);

    return (
        <div className={b(undefined, className)}>
            <div className={b('main')}>
                <img
                    className={b('icon')}
                    src={`${process.env.IMAGES_PATH}/hotelBanner/bannerMobile.jpg`}
                    alt="suburban-icon"
                />
                <div>
                    <div className={b('title')}>{keyset('title')}</div>
                    <div className={b('description')}>
                        {keyset('description', {regionName: region})}
                    </div>
                </div>
            </div>
            <div>
                <Link
                    className={b('buyLink')}
                    href={
                        doesLandingExist
                            ? getHotelRegionUrl({slug}, isProduction)
                            : getHotelSearchUrl(
                                  {geoId, checkinDate},
                                  isProduction,
                              )
                    }
                    rel="nofollow"
                    target="_blank"
                    colors="inherit"
                >
                    {keyset('button-text')}
                </Link>
            </div>
        </div>
    );
};

export default TravelHotelsBanner;
