import {React, B} from '../base';

import SecondaryPosition from '../../interfaces/lib/dimensions/SecondaryPosition';
import PrimaryPosition from '../../interfaces/lib/dimensions/PrimaryPosition';

import passportUrl from '../../lib/url/passportUrl';

import PopupTogglerComponent from '../_mixins/PopupTogglerComponent';
import Popup from '../Popup/Popup';
import Avatar from '../basic/Avatar';
import UserMenu from '../UserMenu/UserMenu';

const b = B('User');

const POPUP_POSITIONS = [
    [PrimaryPosition.bottom, SecondaryPosition.left],
    [PrimaryPosition.bottom, SecondaryPosition.right],
];

export default class User extends PopupTogglerComponent {
    onHide() {
        if (process.env.PLATFORM === 'mobile') {
            this.context.releaseBody();
        }
    }

    onShow() {
        if (process.env.PLATFORM === 'mobile') {
            this.context.fixBody();
        }
    }

    render() {
        const {
            tld,
            fullUrl,

            avatar,
            yandexuid,
            displayName,
            unreadMailCount,
        } = this.props;

        return (
            <div className={b({platform: process.env.PLATFORM})}>
                <div className={b('avatarAndMenu')}>
                    <Avatar
                        path={avatar.default}
                        size={
                            process.env.PLATFORM === 'mobile' ? '32px' : '42px'
                        }
                        onClick={this.onTogglerClick}
                    />

                    <Popup
                        className={b('menuPopup')}
                        positions={POPUP_POSITIONS}
                        visible={this.state.popupVisible}
                        onClickOutside={this.onPopupClickOutside}
                    >
                        <UserMenu
                            tld={tld}
                            fullUrl={fullUrl}
                            yandexuid={yandexuid}
                            unreadMailCount={unreadMailCount}
                        />
                    </Popup>
                </div>

                <a
                    className={b('name')}
                    href={passportUrl(tld, 'passport', {mode: 'passport'})}
                    onClick={this.onTogglerClick}
                >
                    {displayName}
                </a>
            </div>
        );
    }
}
