import {React, PureComponent, B, bindMethods} from '../base';

import {connect} from 'react-redux';

import makeExternalUrl from '../../lib/url/makeExternalUrl';
import passportUrl from '../../lib/url/passportUrl';
import {decodeSpecialCharacters} from '../../lib/stringUtils';
import requestUnreadMailCount from '../../actions/user/requestUnreadMailCount';

import Link from '../Link';

import keyset from '../../i18n/user-menu';

const b = B('UserMenu');

class UserMenu extends PureComponent {
    constructor(props) {
        super(props);
        bindMethods(this, ['onChangeAccount']);
    }

    componentDidMount() {
        const {dispatch} = this.props;

        dispatch(requestUnreadMailCount());
    }

    onChangeAccount(e) {
        this.authForm.uid.value = e.currentTarget.dataset.uid;
        this.authForm.submit();
    }

    render() {
        const {tld, yandexuid, unreadMailCount, fullUrl} = this.props;
        const retpath = decodeSpecialCharacters(fullUrl);

        return (
            <div className={b()}>
                <Link className={b('item')} href={`//mail.yandex.${tld}`}>
                    {keyset('mail', {count: unreadMailCount})}
                </Link>

                <Link
                    className={b('item')}
                    href={`//mail.yandex.${tld}/compose`}
                >
                    {keyset('compose')}
                </Link>

                <Link className={b('item')} href={`//disk.yandex.${tld}`}>
                    {keyset('disk')}
                </Link>

                <hr className={b('separator')} />

                <Link
                    className={b('item')}
                    href={makeExternalUrl(`//yandex.${tld}/tune`, {retpath})}
                >
                    {keyset('tune')}
                </Link>

                <Link
                    className={b('item')}
                    href={passportUrl(tld, 'passport', {mode: 'passport'})}
                >
                    {keyset('passport')}
                </Link>

                <div className={b('accountBlock')}>
                    <Link
                        className={b('accountItem')}
                        href={passportUrl(tld, 'passport', {
                            mode: 'logout',
                            yu: yandexuid,
                            retpath,
                        })}
                    >
                        {keyset('logout')}
                    </Link>
                </div>
            </div>
        );
    }
}

export default connect()(UserMenu);
