import {React, PureComponent, B, mix, PropTypes} from '../base';

import {isWeekend} from '../../lib/date/utils';
import {WEEKDAY_NAMES_SHORT} from '../../lib/date/values';

const b = B('Weekday');

export default class Weekday extends PureComponent {
    static propTypes = {
        weekday: PropTypes.number.isRequired,
        language: PropTypes.string.isRequired,
    };

    render() {
        const {weekday, language, className} = this.props;

        return (
            <li className={mix(b({weekend: isWeekend(weekday)}), className)}>
                {WEEKDAY_NAMES_SHORT[language][weekday]}
            </li>
        );
    }
}
