import {React, PureComponent, mix, PropTypes} from '../base';

import {WEEKDAY_NUMBERS} from '../../lib/date/values';

import Weekday from '../Weekday/Weekday';

const b = 'Weekdays';

export default class Weekdays extends PureComponent {
    static propTypes = {
        language: PropTypes.string.isRequired,

        WeekdayComponent: PropTypes.func,
        weekdayClassName: PropTypes.string,
    };

    static defaultProps = {
        WeekdayComponent: Weekday,
        weekdayClassName: '',
    };

    render() {
        const {className, weekdayClassName, WeekdayComponent, ...props} =
            this.props;

        return (
            <ul className={mix(b, className)}>
                {WEEKDAY_NUMBERS.map(weekday => (
                    <WeekdayComponent
                        {...props}
                        key={weekday}
                        weekday={weekday}
                        className={weekdayClassName}
                    />
                ))}
            </ul>
        );
    }
}
