import {IWithClassName} from 'common/interfaces/components/IWithClassName';
import React, {memo, ReactElement} from 'react';

interface IWrap extends IWithClassName {
    str: string;
    regExp: RegExp;
}

export default memo(WrapSubstring);

// Коспонент для оборачивания подстроки в тэг по решулярному выражению.
function WrapSubstring({str, regExp, className}: IWrap): ReactElement {
    if (
        str.length === 0 ||
        regExp.source.length === 0 ||
        regExp.source === '(?:)'
    ) {
        return <>{str}</>;
    }

    if (!regExp.global) {
        const matchSingle = regExp.exec(str);

        if (!matchSingle) {
            return <>{str}</>;
        }

        const endMatchIndex = matchSingle.index + matchSingle[0].length;

        return (
            <>
                {str.slice(0, matchSingle.index)}
                <span className={className}>
                    {str.slice(matchSingle.index, endMatchIndex)}
                </span>
                {str.slice(endMatchIndex)}
            </>
        );
    }

    const result: (ReactElement | string)[] = [];

    let match: RegExpExecArray | null;
    let lastIndex = 0;

    // eslint-disable-next-line no-cond-assign
    while ((match = regExp.exec(str))) {
        const endMatchIndex = match.index + match[0].length;

        result.push(str.slice(lastIndex, match.index));
        result.push(
            <span className={className} key={match.index}>
                {str.slice(match.index, endMatchIndex)}
            </span>,
        );

        lastIndex = endMatchIndex;
    }

    result.push(str.slice(lastIndex));

    return <>{result}</>;
}
