import React, {ReactElement, memo} from 'react';

interface IYandexLogoProps {
    width?: number;
    height?: number;
    className?: string;
}

export default memo(YandexLogo);

function YandexLogo(props: IYandexLogoProps): ReactElement {
    const {width = 24, height = 24, className} = props;

    return (
        <svg
            width={width}
            height={height}
            className={className}
            xmlns="http://www.w3.org/2000/svg"
            fill="none"
            viewBox="0 0 24 24"
        >
            <mask
                id="yandexLogo"
                width="24"
                height="25"
                x="0"
                y="0"
                maskUnits="userSpaceOnUse"
            >
                <circle cx="12" cy="12.001" r="12" fill="#fff" />
            </mask>
            <g mask="url(#yandexLogo)">
                <path fill="#FC3F1D" d="M0 .001h24v24H0z" />
                <path
                    fill="#fff"
                    d="M13.77 6.721h-1.215c-2.082 0-3.123 1.041-3.123 2.603 0 1.735.694 2.602 2.255 3.643l1.215.868-3.47 5.378H6.656l3.296-4.858c-1.908-1.388-2.949-2.602-2.949-4.858 0-2.776 1.908-4.684 5.552-4.684h3.643v14.4H13.77V6.721Z"
                />
            </g>
        </svg>
    );
}
