import {React, Component} from '../base';

export default function doNotRenderUntil(Class, prop = 'visible', val = true) {
    const shouldBeRendered = props => props[prop] === val;

    return class NoRenderUntilWrapperClass extends Component {
        constructor(props) {
            super(props);

            const rendered = shouldBeRendered(props);

            this.state = {
                rendered,
                initiallyRendered: rendered,
            };
        }

        componentWillReceiveProps(nextProps) {
            if (this.state.rendered) {
                return;
            }

            if (shouldBeRendered(nextProps)) {
                this.setState({rendered: true});
            }
        }

        shouldComponentUpdate(nextProps, nextState) {
            return nextState.rendered;
        }

        render() {
            const {rendered, initiallyRendered} = this.state;

            return (
                rendered && (
                    <Class
                        initiallyRendered={initiallyRendered}
                        {...this.props}
                    />
                )
            );
        }
    };
}
