import PropTypes from 'prop-types';

import {momentTimezone as moment} from '../../../reexports';

import {SUPPORTED_LANGUAGES} from '../../lib/lang/langCodes';
import {WEEKDAY_NUMBERS, SPECIAL_VALUES_PRIORITY} from '../../lib/date/values';

function createValidator(validator) {
    const result = (props, propName, componentName) => {
        if (typeof props[propName] === 'undefined') {
            return;
        }

        return validator(props, propName, componentName);
    };

    result.isRequired = validator;

    return result;
}

function createValidationError(props, propName, componentName, typeName) {
    return new Error(
        `Component "${componentName}" propType validation failed:
        expected property "${propName}" to be of "${typeName}" type, but got "${props[propName]}" instead.`,
    );
}

const propTypes = {
    ...PropTypes,

    time: PropTypes.oneOfType([
        PropTypes.instanceOf(moment),
        PropTypes.shape({
            now: PropTypes.number.isRequired,
            timezone: PropTypes.string.isRequired,
        }),
    ]),

    language: PropTypes.oneOf(SUPPORTED_LANGUAGES),

    weekdayNumber: PropTypes.oneOf(WEEKDAY_NUMBERS),

    point: PropTypes.shape({
        title: PropTypes.string,
        key: PropTypes.number,
    }),

    datePickerSpecialValue: PropTypes.oneOf(SPECIAL_VALUES_PRIORITY),

    moment: createValidator((props, propName, componentName) => {
        if (!moment.isMoment(props[propName])) {
            return createValidationError(
                props,
                propName,
                componentName,
                'moment',
            );
        }
    }),
};

propTypes.datePickerValue = propTypes.shape({
    date: propTypes.string,
    text: propTypes.string,
    weekday: propTypes.weekdayNumber,
    special: propTypes.datePickerSpecialValue,
    formatted: propTypes.string,
    hint: propTypes.string,
});

propTypes.momentRange = propTypes.shape({
    start: propTypes.moment.isRequired,
    end: propTypes.moment.isRequired,
});

export default propTypes;
