import _set from 'lodash/set';
import React, {Component, PureComponent as ReactPureComponent} from 'react';

import PropTypes from './_utils/propTypes';

import {makeCacheable} from '../lib/cache';

class BaseComponent<P, S> extends Component<P, S> {}

class PureComponent<P, S> extends ReactPureComponent<P, S> {}

class ConstantComponent<P, S> extends BaseComponent<P, S> {
    shouldComponentUpdate(): boolean {
        return false;
    }
}

export {mix} from '../lib/stringUtils';
export {connect} from 'react-redux';
export {bindMethods} from '../lib/objectUtils';
export {default as B} from 'bem-cn-lite';
export {
    React,
    PropTypes,
    BaseComponent as Component,
    PureComponent,
    ConstantComponent,
};

export const refCallback = makeCacheable((ctx, ...path) => ref => {
    _set(ctx, path, ref);
});
