import {React, B, mix} from '../../base';

const b = B('Avatar');

export default function Avatar({path, onClick, className, size = '42px'}) {
    return (
        <img
            className={mix(b(), className)}
            width={size}
            height={size}
            onClick={onClick}
            src={`//avatars.mds.yandex.net/get-yapic/${path}/islands-middle`}
            srcSet={`//avatars.mds.yandex.net/get-yapic/${path}/islands-retina-middle 2x`}
        />
    );
}
