import {React, B, mix} from '../../base';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import noop from '../../../lib/noop';

import Icon from '../../Icon/Icon';
import Button from '../../Button/Button';

const b = B('ClearButton');

export default function ClearButton({
    className,
    onClick = noop,
    visible = true,
}) {
    return (
        <Button className={mix(b({visible}), className)} onClick={onClick}>
            <Icon glyph={IconGlyph.cross} className={b('clearIcon')} />
        </Button>
    );
}
