import {React, PureComponent, B} from '../../base';

import {momentTimezone as moment} from '../../../../reexports';

import getAvailableLanguages from '../../../lib/lang/getAvailableLanguages';
import insertMarkupIntoKey from '../../../i18n/_utils/insertMarkupIntoKey';

import Link from '../../Link';
import LangSwitcher from '../../LangSwitcher/LangSwitcher';

import linkKeyset from '../../../i18n/foot-links';
import footerKeyset from '../../../i18n/footer';
import getHelpUrl from '../../../lib/url/getHelpUrl';

const b = B('Footer');

export default class Footer extends PureComponent {
    render() {
        const {
            tld,
            now,
            user,
            page,
            timezone,
            language,
            layout,
            pageType,
            throwError,
        } = this.props;

        if (throwError === 'specialErrorInFooterRender') {
            throw new Error(throwError);
        }

        const links = {
            advertising: {
                ru: '//advertising.yandex.ru/media/banner/schedule.xml?from=rasp-ru',
                ua: '//advertising.yandex.ua/media/',
                by: '//advertising.yandex.by/media/',
                uz: '//yandex.uz/adv/products/display',
                kz: '//yandex.kz/adv/products/display',
            },
        };

        const copyrightLink = (
            <Link href={`//yandex.${tld}`} key="copyrightLink">
                {footerKeyset('link-copyright')}
            </Link>
        );

        const copyright = insertMarkupIntoKey(footerKeyset, 'copyright', {
            start: 2009,
            end: moment.tz(now, timezone).year(),
            link: copyrightLink,
        });

        const availableLanguages = getAvailableLanguages(tld);

        return (
            <footer className={b({layout, pageType})}>
                <ul className={b('inner')}>
                    <li className={b('item')}>
                        <Link
                            href={`//legal.yandex.${tld}/timetable_termsofuse`}
                            rel="nofollow"
                        >
                            {footerKeyset('link-termsofuse')}
                        </Link>
                    </li>

                    <li className={b('item')}>
                        <Link href="/info/partners">
                            {linkKeyset('link-partners')}
                        </Link>
                    </li>

                    <li className={b('item')}>
                        <Link rel="nofollow" href={getHelpUrl(tld)}>
                            {footerKeyset('link-help')}
                        </Link>
                    </li>

                    <li className={b('item')}>
                        <Link
                            rel="nofollow"
                            href={`//yandex.${tld}/support/rasp/troubleshooting.html?form1645-answer_short_text_25924=desktop`}
                        >
                            {footerKeyset('link-feedback')}
                        </Link>
                    </li>

                    <li className={b('item')}>
                        <Link href={links.advertising[tld]} rel="nofollow">
                            {footerKeyset('link-advertising')}
                        </Link>
                    </li>

                    {availableLanguages.length > 1 && (
                        <li className={b('item')}>
                            <LangSwitcher
                                tld={tld}
                                user={user}
                                page={page}
                                language={language}
                                availableLanguages={availableLanguages}
                            />
                        </li>
                    )}

                    <li className={b('copyright')}>{copyright}</li>
                </ul>
            </footer>
        );
    }
}
