import {React, PureComponent, B, PropTypes} from '../../base';

import {ABOUT_TRAINS} from '../../../lib/constants/homepageBlocks';

import getTrainDomain from '../../../lib/url/getTrainDomain';
import shouldShowBlockForCountry from '../../../lib/shouldShowBlockForCountry';
import applyUtm from '../../../lib/url/applyUtm';

import Link from '../../Link';

import keyset from '../../../i18n/foot-links';

const b = B('FooterInformation');

const isMobile = process.env.PLATFORM === 'mobile';

export default class FooterInformation extends PureComponent {
    static propTypes = {
        mods: PropTypes.object,
    };

    static defaultProps = {
        mods: {},
    };

    render() {
        const {pageType, tld, isProduction, seoQueryParams, clientId} =
            this.props;

        const linkGroups = [
            {
                type: 'carriers',
                title: keyset('title-carriers'),
                items: [
                    {
                        title: keyset('link-format'),
                        href: '/info/format/',
                        id: 'format',
                    },
                ],
            },
            {
                type: 'service',
                title: keyset('title-service'),
                items: shouldShowBlockForCountry(ABOUT_TRAINS, tld)
                    ? [
                          {
                              title: keyset('link-trains'),
                              href: applyUtm(
                                  getTrainDomain(isProduction),
                                  seoQueryParams,
                                  clientId,
                                  'trains_footer',
                              ),
                              id: 'trains',
                          },
                          {
                              title: keyset('link-wagons'),
                              href: '/info/vagons/',
                              id: 'vagons',
                          },
                          {
                              title: keyset(
                                  'link-electronic-ticket-requirements',
                              ),
                              href: 'https://yandex.ru/legal/train_tickets_booking_conditions/',
                              id: 'electronicTicketRequirements',
                          },
                      ]
                    : [],
            },
            {
                type: 'info',
                title: keyset('title-info'),
                items: [
                    {
                        title: keyset(
                            'link-airport-station-and-panel-informers',
                        ),
                        href: '/informers/informer/',
                        id: 'airport-station-and-panel-informers',
                    },
                    {
                        title: keyset('link-print'),
                        href: '/print/schedule/',
                        id: 'schedule',
                    },
                ],
            },
        ];

        const notNeededOnMobileLinks = [
            'schedule',
            'widget',
            'airport-station-and-panel-informers',
        ];

        if (isMobile) {
            linkGroups[2].items = linkGroups[2].items.filter(
                ({id}) => !notNeededOnMobileLinks.includes(id),
            );

            if (!linkGroups[2].items.length) {
                linkGroups.splice(2, 1);
            }
        }

        return (
            <div className={b({pageType, isMobile})}>
                {linkGroups.map(
                    (group, groupIndex) =>
                        Boolean(group.items.length) && (
                            <div
                                key={groupIndex}
                                className={b('group', {type: group.type})}
                            >
                                <h4 className={b('title')}>{group.title}</h4>

                                <ul className={b('list')}>
                                    {group.items.map(
                                        ({title, href, target}, itemIndex) => (
                                            <li
                                                key={itemIndex}
                                                className={b('item')}
                                            >
                                                <Link
                                                    href={href}
                                                    target={target}
                                                >
                                                    {title}
                                                </Link>
                                            </li>
                                        ),
                                    )}
                                </ul>
                            </div>
                        ),
                )}
            </div>
        );
    }
}
