import {React, B, mix, PropTypes} from '../../base';

import {connect} from 'react-redux';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import TooltipComponent from '../../_mixins/TooltipComponent';

import Icon from '../../Icon/Icon';

const b = B('InformationIcon');

class InformationIcon extends TooltipComponent {
    static propTypes = {
        hint: PropTypes.string.isRequired, // текст в попапе
        className: PropTypes.string,
        title: PropTypes.string,
        size: PropTypes.oneOf(['small', 'huge']),
        thin: PropTypes.bool,
    };

    static defaultProps = {
        size: 'small',
        thin: false,
    };

    render() {
        const {className, title, size, thin, inactive} = this.props;
        const hasTitle = Boolean(title);
        const glyph = thin ? IconGlyph.informationThin : IconGlyph.information;

        return (
            <div
                className={mix(b({hasTitle, size}), className)}
                onMouseEnter={!inactive ? this.onMouseEnter : undefined}
                onMouseLeave={!inactive ? this.onMouseLeave : undefined}
            >
                {hasTitle && <span className={b('title')}>{title}</span>}

                <Icon className={b('icon')} glyph={glyph} />
            </div>
        );
    }
}

export default connect()(InformationIcon);
