import React, {ReactElement, memo, useEffect, useMemo} from 'react';
import B from 'bem-cn-lite';

import {reachGoalOnce} from '../../../lib/yaMetrika';

import Spinner from '../../Spinner/Spinner';

import keyset from '../../../i18n/chunks';

const b = B('LoadingChunk');

interface ILoadingChunk {
    className?: string;
    pastDelay?: boolean | number;
    error?: string | object;
}

export default memo(LoadingChunk);

function LoadingChunk({
    className,
    pastDelay = true,
    error,
}: ILoadingChunk): ReactElement | null {
    useEffect(() => {
        if (error) {
            reachGoalOnce('chunk_loading_failed');
        }
    });

    const content = useMemo(() => {
        if (error) {
            reachGoalOnce('chunk_loading_failed');

            return <div className={b('error')}>{keyset('error')}</div>;
        }

        if (pastDelay) {
            return (
                <div className={b('loading')}>
                    <Spinner className={b('spinner')} />

                    <div className={b('loadingText')}>{keyset('loading')}</div>
                </div>
            );
        }

        return null;
    }, [error, pastDelay]);

    if (!content) {
        return null;
    }

    return <div className={b(undefined, className)}>{content}</div>;
}
