import React, {memo, useContext} from 'react';
import B from 'bem-cn-lite';

import IconGlyph from '../../../interfaces/components/IconGlyph';

import {reachGoalOnce} from '../../../lib/yaMetrika';
import getTravelDomain from '../../../lib/url/getTravelDomain';
import getCrowdTestingUrl from '../../../lib/url/getCrowdTestingUrl';
import applyUtm from '../../../lib/url/applyUtm';
import useSelector from '../../useSelector';

import StaticContext from '../../StaicContext/StaticContext';
import Icon from '../../Icon/Icon';

import keyset from '../../../i18n/personal';
import {IWithClassName} from 'common/interfaces/components/IWithClassName';

const b = B('OrdersLink');

interface IOrdersLinkProps extends IWithClassName {}

function onClick(): void {
    reachGoalOnce('orders_link_click');
}

export default memo(OrdersLink);

function OrdersLink({className}: IOrdersLinkProps): React.ReactElement {
    const isProduction = useSelector(state => state.environment.production);
    const seoQueryParams = useSelector(state => state.seoQueryParams);
    const clientId = useSelector(state => state.user.clientId);
    const {isCrowdTesting} = useContext(StaticContext);

    const title = keyset('orders-link-title');
    let ordersLink = applyUtm(
        getTravelDomain({isProduction}),
        seoQueryParams,
        clientId,
        'main_order',
    );

    if (isCrowdTesting && ordersLink) {
        ordersLink = getCrowdTestingUrl(ordersLink);
    }

    return (
        <a
            href={ordersLink}
            className={b(undefined, className)}
            onClick={onClick}
        >
            <figure className={b('ticketFigure')} aria-label={title}>
                <Icon className={b('ticketIcon')} glyph={IconGlyph.ticket} />
            </figure>

            <span className={b('title')}>{title}</span>
        </a>
    );
}
